#############################################################
#
# mpd
#
#############################################################
MPD_VERSION:=0.13.0
MPD_SOURCE:=mpd-$(MPD_VERSION).tar.bz2

MPD_SITE:=http://musicpd.org/uploads/files/
MPD_DIR:=$(BUILD_DIR)/mpd-$(MPD_VERSION)

MPD_BINARY:=mpd
MPD_TARGET_BINARY:=usr/bin/mpd

#
# download source
#
$(DL_DIR)/$(MPD_SOURCE):
	 $(WGET) -P $(DL_DIR) $(MPD_SITE)/$(MPD_SOURCE) 

#
# unpack source and potentially patch package; use bzcat for bz2 files
#
$(MPD_DIR)/.unpacked: $(DL_DIR)/$(MPD_SOURCE)
	bzcat $(DL_DIR)/$(MPD_SOURCE) | tar -C $(BUILD_DIR) $(TAR_OPTIONS) -
	touch $@

#
# configure source, add additional options to configure as required
# call ./configure --help to find out about additional options
#
$(MPD_DIR)/.configured: $(MPD_DIR)/.unpacked
	( \
		cd $(MPD_DIR) ; \
		$(TARGET_CONFIGURE_OPTS) \
		LDFLAGS=-L${TARGET_DIR}/usr/lib \
		CPPFLAGS=-I${TARGET_DIR}/usr/include \
		./configure --prefix=/usr --disable-nls \
		--with-mad=${TARGET_DIR}/usr/ \
		--with-id3tag=${TARGET_DIR}/usr/; \
		sed -i -e "s#-lmad#$${TARGET_DIR}/usr/lib/libmad.a#;s#-lid3tag#${TARGET_DIR}/usr/lib/libid3tag.a#" src/Makefile ; \
	)
	touch  $@

#
# build package
# 
$(MPD_DIR)/$(MPD_BINARY): $(MPD_DIR)/.configured
	$(MAKE) -C $(MPD_DIR) CC=$(TARGET_CC) 

#
# install package
#
$(TARGET_DIR)/$(MPD_TARGET_BINARY): $(MPD_DIR)/$(MPD_BINARY)
	$(FAKEROOT) $(MAKE) -C $(MPD_DIR) DESTDIR=$(TARGET_DIR) install
	$(STRIP) $@
#
# to get mpd, we need $(TARGET_DIR)/usr/sbin/mpd
#   - to get $(TARGET_DIR)/usr/sbin/mpd, we need $(MPD_DIR)/mpd
#      - before trying to build mpd, we need
#        $(MPD_DIR)/.configured
#        ...
mpd: $(TARGET_DIR)/$(MPD_TARGET_BINARY) libid3tag libmad

mpd-source: $(DL_DIR)/$(MPD_SOURCE)

mpd-clean:
	$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(MPD_DIR) uninstall
	-$(MAKE) -C $(MPD_DIR) clean

mpd-dirclean:
	rm -rf $(MPD_DIR)

#############################################################
#
# Toplevel Makefile options
#
#############################################################
# ifeq ($(strip $(BR2_PACKAGE_MPD)),y)
TARGETS+=mpd
# endif
