#############################################################
#
# mpc
#
#############################################################
MPC_VERSION:=0.12.1
MPC_SOURCE:=mpc-$(MPC_VERSION).tar.bz2

MPC_SITE:=http://musicpd.org/uploads/files/
MPC_DIR:=$(BUILD_DIR)/mpc-$(MPC_VERSION)

MPC_BINARY:=mpc
MPC_TARGET_BINARY:=usr/bin/mpc

#
# download source
#
$(DL_DIR)/$(MPC_SOURCE):
	 $(WGET) -P $(DL_DIR) $(MPC_SITE)/$(MPC_SOURCE) 

#
# unpack source and potentially patch package; use bzcat for bz2 files
#
$(MPC_DIR)/.unpacked: $(DL_DIR)/$(MPC_SOURCE)
	bzcat $(DL_DIR)/$(MPC_SOURCE) | tar -C $(BUILD_DIR) $(TAR_OPTIONS) -
	touch $@

#
# configure source, add additional options to configure as required
# call ./configure --help to find out about additional options
#
$(MPC_DIR)/.configured: $(MPC_DIR)/.unpacked
	( cd $(MPC_DIR) ; \
	$(TARGET_CONFIGURE_OPTS) ./configure --prefix=/usr --disable-nls ;\
	sed -i -e 's/ -liconv/#-liconv/' src/Makefile )
	touch  $@

#
# build package
# 
$(MPC_DIR)/$(MPC_BINARY): $(MPC_DIR)/.configured
	$(MAKE) -C $(MPC_DIR) CC=$(TARGET_CC) 

#
# install package
#
$(TARGET_DIR)/$(MPC_TARGET_BINARY): $(MPC_DIR)/$(MPC_BINARY)
	$(FAKEROOT) $(MAKE) -C $(MPC_DIR) DESTDIR=$(TARGET_DIR) install
	$(STRIP) $@
#
# to get mpc, we need $(TARGET_DIR)/usr/sbin/mpc
#   - to get $(TARGET_DIR)/usr/sbin/mpc, we need $(MPC_DIR)/mpc
#      - before trying to build mpc, we need
#        $(MPC_DIR)/.configured
#        ...
mpc: $(TARGET_DIR)/$(MPC_TARGET_BINARY)

mpc-source: $(DL_DIR)/$(MPC_SOURCE)

mpc-clean:
	$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(MPC_DIR) uninstall
	-$(MAKE) -C $(MPC_DIR) clean

mpc-dirclean:
	rm -rf $(MPC_DIR)

#############################################################
#
# Toplevel Makefile options
#
#############################################################
# ifeq ($(strip $(BR2_PACKAGE_MPC)),y)
TARGETS+=mpc
# endif
