#############################################################
#
# libmad
#
#############################################################
LIBMAD_VERSION:=0.15.1b
LIBMAD_SOURCE:=libmad-$(LIBMAD_VERSION).tar.gz

LIBMAD_SITE:=http://$(SF_DL_HOST)/sourceforge/mad/
LIBMAD_DIR:=$(BUILD_DIR)/libmad-$(LIBMAD_VERSION)

LIBMAD_LIBRARY:=libmad.a
LIBMAD_TARGET_LIBRARY:=usr/lib/libmad.a

#
# download source
#
$(DL_DIR)/$(LIBMAD_SOURCE):
	 $(WGET) -P $(DL_DIR) $(LIBMAD_SITE)/$(LIBMAD_SOURCE) 

#
# unpack source and potentially patch package; use bzcat for bz2 files
#
$(LIBMAD_DIR)/.unpacked: $(DL_DIR)/$(LIBMAD_SOURCE)
	zcat $(DL_DIR)/$(LIBMAD_SOURCE) | tar -C $(BUILD_DIR) $(TAR_OPTIONS) -
	toolchain/patch-kernel.sh $(LIBMAD_DIR) package/mpd \
	     libmad-\*.patch
	touch $@

#
# configure source, add additional options to configure as required
# call ./configure --help to find out about additional options
#
$(LIBMAD_DIR)/.configured: $(LIBMAD_DIR)/.unpacked
	( cd $(LIBMAD_DIR) ; $(TARGET_CONFIGURE_OPTS) ./configure --prefix=/usr --disable-nls )
	touch  $@

#
# build package
# 
$(LIBMAD_DIR)/$(LIBMAD_LIBRARY): $(LIBMAD_DIR)/.configured
	$(MAKE) -C $(LIBMAD_DIR) CC=$(TARGET_CC) 

#
# install package
#
$(TARGET_DIR)/$(LIBMAD_TARGET_LIBRARY): $(LIBMAD_DIR)/$(LIBMAD_LIBRARY)
	$(FAKEROOT) $(MAKE) -C $(LIBMAD_DIR) DESTDIR=$(TARGET_DIR) install

libmad: $(TARGET_DIR)/$(LIBMAD_TARGET_LIBRARY)

libmad-source: $(DL_DIR)/$(LIBMAD_SOURCE)

libmad-clean:
	$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(LIBMAD_DIR) uninstall
	-$(MAKE) -C $(LIBMAD_DIR) clean

libmad-dirclean:
	rm -rf $(LIBMAD_DIR)

#############################################################
#
# Toplevel Makefile options
#
#############################################################
# ifeq ($(strip $(BR2_PACKAGE_LIBMAD)),y)
TARGETS+=libmad
# endif
