#############################################################
#
# madwifi
#
#############################################################
MADWIFI_VER:=old-r1417-20060128
MADWIFI_SOURCE_URL:=http://snapshots.madwifi.org/madwifi-old
MADWIFI_SOURCE:=madwifi-$(MADWIFI_VER).tar.gz
MADWIFI_BUILD_DIR:=$(BUILD_DIR)/madwifi-$(MADWIFI_VER)
#
# download source
#
$(DL_DIR)/$(MADWIFI_SOURCE):
	 $(WGET) -P $(DL_DIR) $(MADWIFI_SOURCE_URL)/$(MADWIFI_SOURCE) 

#
# unpack source and potentially patch package; use zcat for gz files
#
$(MADWIFI_BUILD_DIR)/noask: $(DL_DIR)/$(MADWIFI_SOURCE)
	zcat $(DL_DIR)/$(MADWIFI_SOURCE) | tar -C $(BUILD_DIR) $(TAR_OPTIONS) -
#	mv $(BUILD_DIR)/madwifi-* $(MADWIFI_BUILD_DIR)
#	sed -i -e 's#/sbin/depmod -ae -b.*#true ;\\#' $(MADWIFI_BUILD_DIR)/Makefile
	sed -i -e 's/ "ath%d"/ "eth%d"/g' $(MADWIFI_BUILD_DIR)/ath/if_ath.c
	touch $@

#
# build package
# 
$(MADWIFI_BUILD_DIR)/ath/ath_pci.o: $(MADWIFI_BUILD_DIR)/noask
	$(MAKE) -C $(MADWIFI_BUILD_DIR) \
		KERNELPATH=$(LINUX_DIR) \
		KERNELRELEASE=$(LINUX_VERSION) \
		COPTS="$(TARGET_CONFIGURE_CFLAGS) -DATH_PCI -DATH_SUPERG_FF=1 -DATH_SUPERG_DYNTURBO=1 -DATH_TURBO_SCAN=1" \
		CC=$(TARGET_CC)

#
# install package
#
$(TARGET_DIR)/lib/modules/$(LINUX_VERSION)/kernel/drivers/net/ath_pci.o: $(MADWIFI_BUILD_DIR)/ath/ath_pci.o
	$(MAKE) -C $(MADWIFI_BUILD_DIR) \
		KERNELPATH=$(LINUX_DIR) \
		KERNELRELEASE=$(LINUX_VERSION) \
		CC=$(TARGET_CC) \
		DESTDIR=$(TARGET_DIR) \
		MODULEPATH=/lib/modules/$(LINUX_VERSION)/kernel/drivers/net \
		install

madwifi: $(TARGET_DIR)/lib/modules/$(LINUX_VERSION)/kernel/drivers/net/ath_pci.o

madwifi-source: $(DL_DIR)/$(MADWIFI_SOURCE)

madwifi-clean:
	-$(MAKE) -C $(MADWIFI_BUILD_DIR) KERNELPATH=$(LINUX_DIR) clean

madwifi-dirclean:
	rm -rf $(MADWIFI_BUILD_DIR)
